<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title><?php echo e(config('app.name', 'WhatsApp Grow')); ?> - The Simple Way to Grow Your Community</title>

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Outfit:wght@300;400;600;800;900&display=swap" rel="stylesheet">

    <!-- Styles -->
    <?php echo app('Illuminate\Foundation\Vite')(['resources/css/app.css', 'resources/js/app.js']); ?>

    <style>
        body {
            font-family: 'Outfit', sans-serif;
            background-color: #020617;
            /* Even deeper slate/black */
            color: #f8fafc;
            overflow-x: hidden;
        }

        .hero-gradient {
            background: radial-gradient(circle at top left, rgba(30, 58, 138, 0.4) 0%, transparent 70%),
                radial-gradient(circle at bottom right, rgba(212, 175, 55, 0.08) 0%, transparent 70%);
        }

        .v2-gradient {
            background: linear-gradient(135deg, #1E3A8A 0%, #111827 100%);
        }

        .gold-glow {
            box-shadow: 0 0 50px -10px rgba(212, 175, 55, 0.15);
        }

        .glass-card {
            background: rgba(255, 255, 255, 0.02);
            backdrop-filter: blur(16px);
            border: 1px solid rgba(255, 255, 255, 0.08);
        }

        .hover-glow:hover {
            border-color: rgba(212, 175, 55, 0.3);
            background: rgba(255, 255, 255, 0.04);
            transform: translateY(-8px);
        }

        .accent-text {
            background: linear-gradient(to right, #D4AF37, #fde68a);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
        }

        .step-number {
            background: linear-gradient(135deg, #D4AF37 0%, #fde68a 100%);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
        }
    </style>
</head>

<body class="antialiased selection:bg-[#D4AF37] selection:text-white">
    <!-- Header -->
    <header class="fixed top-0 w-full z-50 bg-[#020617]/80 backdrop-blur-xl border-b border-white/5">
        <nav class="max-w-7xl mx-auto px-6 h-20 flex items-center justify-between">
            <div class="flex items-center gap-3">
                <div
                    class="w-10 h-10 bg-indigo-950 rounded-xl flex items-center justify-center border border-white/10 shadow-lg">
                    <svg class="w-6 h-6 text-[#D4AF37]" fill="currentColor" viewBox="0 0 24 24">
                        <path d="M12 2L2 7l10 5 10-5-10-5zM2 17l10 5 10-5M2 12l10 5 10-5" />
                    </svg>
                </div>
                <span class="text-2xl font-black tracking-tight text-white">WhatsApp<span
                        class="text-[#D4AF37]">Grow</span></span>
            </div>

            <div class="hidden md:flex items-center gap-8 text-[10px] font-black uppercase tracking-widest">
                <?php if(auth()->guard()->check()): ?>
                    <a href="<?php echo e(url('/dashboard')); ?>" class="text-gray-400 hover:text-white transition">My Dashboard</a>
                <?php else: ?>
                    <a href="<?php echo e(route('login')); ?>" class="text-gray-400 hover:text-white transition">Log in</a>
                    <a href="<?php echo e(route('register')); ?>"
                        class="v2-gradient px-8 py-3 rounded-full text-white border border-white/10 hover:border-[#D4AF37] transition-all gold-glow">Get
                        Started Free</a>
                <?php endif; ?>
            </div>
        </nav>
    </header>

    <main class="hero-gradient">
        <!-- Hero Section -->
        <section class="min-h-screen flex items-center pt-28 px-6 max-w-7xl mx-auto">
            <div class="max-w-4xl space-y-10">
                <div
                    class="inline-flex items-center gap-3 px-4 py-1.5 rounded-full glass-card border-white/5 text-[9px] font-black uppercase tracking-[0.3em] text-[#D4AF37]">
                    <span class="w-2 h-2 rounded-full bg-[#D4AF37] animate-pulse"></span>
                    Now LIVE: The most trusted growth network
                </div>
                <h1 class="text-6xl md:text-9xl font-black leading-[1] tracking-tighter">
                    Grow Fast. <br>
                    <span class="accent-text">Earn Real.</span>
                </h1>
                <p class="text-xl text-gray-400 font-medium leading-relaxed max-w-2xl">
                    Join the premier network connecting brands looking for members with promoters ready to share. No
                    bots, no fake links—just pure growth for everyone.
                </p>
                <div class="flex flex-wrap gap-6 pt-4">
                    <a href="<?php echo e(route('register')); ?>"
                        class="v2-gradient px-12 py-5 rounded-full text-white font-black text-xs uppercase tracking-widest shadow-2xl gold-glow hover:scale-105 transition-all">
                        Create Your Account
                    </a>
                    <a href="#how-it-works"
                        class="px-12 py-5 rounded-full bg-white/5 border border-white/10 text-white font-black text-xs uppercase tracking-widest hover:bg-white/10 transition-all">
                        How it Works
                    </a>
                </div>
            </div>
        </section>

        <!-- Stats Section -->
        <section class="py-24 border-t border-white/5 px-6 max-w-7xl mx-auto">
            <div class="grid grid-cols-2 md:grid-cols-4 gap-8">
                <div class="text-center p-6 bg-white/5 rounded-2xl border border-white/5">
                    <div class="text-3xl font-black text-white mb-1">50k+</div>
                    <div class="text-[9px] font-bold uppercase tracking-widest text-[#D4AF37]">Active Members</div>
                </div>
                <div class="text-center p-6 bg-white/5 rounded-2xl border border-white/5">
                    <div class="text-3xl font-black text-white mb-1">$10k+</div>
                    <div class="text-[9px] font-bold uppercase tracking-widest text-[#D4AF37]">Paid to Promoters</div>
                </div>
                <div class="text-center p-6 bg-white/5 rounded-2xl border border-white/5">
                    <div class="text-3xl font-black text-white mb-1">200+</div>
                    <div class="text-[9px] font-bold uppercase tracking-widest text-[#D4AF37]">Daily Campaigns</div>
                </div>
                <div class="text-center p-6 bg-white/5 rounded-2xl border border-white/5">
                    <div class="text-3xl font-black text-white mb-1">100%</div>
                    <div class="text-[9px] font-bold uppercase tracking-widest text-[#D4AF37]">Real & Verified</div>
                </div>
            </div>
        </section>

        <!-- "How It Works" Educational Section -->
        <section id="how-it-works" class="py-32 bg-black/40 border-y border-white/5 px-6">
            <div class="max-w-7xl mx-auto">
                <div class="text-center space-y-4 mb-24">
                    <h2 class="text-xs font-black uppercase tracking-[0.5em] text-[#D4AF37]">The Simple Path</h2>
                    <h3 class="text-4xl md:text-6xl font-black tracking-tight">How WhatsApp Grow Works</h3>
                </div>

                <div class="grid md:grid-cols-2 gap-16 lg:gap-32">
                    <!-- Path 1: For Brands -->
                    <div class="space-y-12">
                        <div class="flex items-center gap-6 pb-6 border-b border-white/5">
                            <div
                                class="w-14 h-14 bg-[#D4AF37]/10 rounded-2xl flex items-center justify-center border border-[#D4AF37]/20">
                                <svg class="w-8 h-8 text-[#D4AF37]" fill="none" stroke="currentColor"
                                    viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1m-5 10v-5a1 1 0 011-1h2a1 1 0 011 1v5m-4 0h4" />
                                </svg>
                            </div>
                            <div>
                                <h4 class="text-3xl font-black uppercase tracking-tight">For <span
                                        class="accent-text">Brands</span></h4>
                                <p class="text-xs font-bold text-gray-500 uppercase tracking-widest">Growth for your
                                    group</p>
                            </div>
                        </div>

                        <div class="space-y-10">
                            <!-- Step 1 -->
                            <div class="flex gap-8 group">
                                <div
                                    class="text-5xl font-black step-number opacity-20 group-hover:opacity-100 transition-all">
                                    01</div>
                                <div class="space-y-2">
                                    <h5 class="text-xl font-bold text-white">Post Your Group</h5>
                                    <p class="text-gray-400 leading-relaxed">Deposit funds and paste your WhatsApp group
                                        link. Tell us how many members you want to join.</p>
                                </div>
                            </div>
                            <!-- Step 2 -->
                            <div class="flex gap-8 group">
                                <div
                                    class="text-5xl font-black step-number opacity-20 group-hover:opacity-100 transition-all">
                                    02</div>
                                <div class="space-y-2">
                                    <h5 class="text-xl font-bold text-white">Promoters Share</h5>
                                    <p class="text-gray-400 leading-relaxed">Thousands of real people see your link and
                                        share it with their communities and relevant groups.</p>
                                </div>
                            </div>
                            <!-- Step 3 -->
                            <div class="flex gap-8 group">
                                <div
                                    class="text-5xl font-black step-number opacity-20 group-hover:opacity-100 transition-all">
                                    03</div>
                                <div class="space-y-2">
                                    <h5 class="text-xl font-bold text-white">Verified Growth</h5>
                                    <p class="text-gray-400 leading-relaxed">Our system checks every join. You only pay
                                        for real members who actually join and stay in your group.</p>
                                </div>
                            </div>
                        </div>
                        <a href="<?php echo e(route('register')); ?>"
                            class="inline-block mt-4 text-[11px] font-black uppercase tracking-[0.3em] text-[#D4AF37] hover:underline decoration-2 underline-offset-8">Register
                            as a Brand &rarr;</a>
                    </div>

                    <!-- Path 2: For Promoters -->
                    <div class="space-y-12">
                        <div class="flex items-center gap-6 pb-6 border-b border-white/5">
                            <div
                                class="w-14 h-14 bg-blue-500/10 rounded-2xl flex items-center justify-center border border-blue-500/20">
                                <svg class="w-8 h-8 text-blue-400" fill="none" stroke="currentColor"
                                    viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M17 20h5v-2a3 3 0 00-5.356-1.857M17 20H7m10 0v-2c0-.656-.126-1.283-.356-1.857M7 20H2v-2a3 3 0 015.356-1.857M7 20v-2c0-.656.126-1.283.356-1.857m0 0a5.002 5.002 0 019.288 0M15 7a3 3 0 11-6 0 3 3 0 016 0zm6 3a2 2 0 11-4 0 2 2 0 014 0zM7 10a2 2 0 11-4 0 2 2 0 014 0z" />
                                </svg>
                            </div>
                            <div>
                                <h4 class="text-3xl font-black uppercase tracking-tight">For <span
                                        class="text-blue-400">Promoters</span></h4>
                                <p class="text-xs font-bold text-gray-500 uppercase tracking-widest">Share links to earn
                                </p>
                            </div>
                        </div>

                        <div class="space-y-10">
                            <!-- Step 1 -->
                            <div class="flex gap-8 group">
                                <div
                                    class="text-5xl font-black opacity-20 group-hover:opacity-100 transition-all text-white">
                                    01</div>
                                <div class="space-y-2">
                                    <h5 class="text-xl font-bold text-white">Join Campaigns</h5>
                                    <p class="text-gray-400 leading-relaxed">Browse active growth campaigns and pick the
                                        groups that fit your audience perfectly.</p>
                                </div>
                            </div>
                            <!-- Step 2 -->
                            <div class="flex gap-8 group">
                                <div
                                    class="text-5xl font-black opacity-20 group-hover:opacity-100 transition-all text-white">
                                    02</div>
                                <div class="space-y-2">
                                    <h5 class="text-xl font-bold text-white">Share Your Link</h5>
                                    <p class="text-gray-400 leading-relaxed">Get a unique tracking link and share it on
                                        WhatsApp, Social Media, or with your friends.</p>
                                </div>
                            </div>
                            <!-- Step 3 -->
                            <div class="flex gap-8 group">
                                <div
                                    class="text-5xl font-black opacity-20 group-hover:opacity-100 transition-all text-white">
                                    03</div>
                                <div class="space-y-2">
                                    <h5 class="text-xl font-bold text-white">Get Paid Fast</h5>
                                    <p class="text-gray-400 leading-relaxed">Earn money for every verified member that
                                        joins through your link. Withdraw instantly to your bank.</p>
                                </div>
                            </div>
                        </div>
                        <a href="<?php echo e(route('register')); ?>"
                            class="inline-block mt-4 text-[11px] font-black uppercase tracking-[0.3em] text-blue-400 hover:underline decoration-2 underline-offset-8">Register
                            as a Promoter &rarr;</a>
                    </div>
                </div>
            </div>
        </section>

        <!-- Value Proposition Section -->
        <section class="py-32 px-6 max-w-7xl mx-auto">
            <div class="grid md:grid-cols-3 gap-8">
                <div class="glass-card p-12 rounded-[2.5rem] space-y-6 hover-glow transition-all">
                    <div
                        class="w-12 h-12 bg-green-500/10 rounded-xl flex items-center justify-center border border-green-500/20">
                        <svg class="w-6 h-6 text-green-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M9 12l2 2 4-4m5.618-4.016A11.955 11.955 0 0112 2.944a11.955 11.955 0 01-8.618 3.040 12.02 12.02 0 00-3 9c0 5.592 3.824 10.29 9 11.622 5.176-1.332 9-6.03 9-11.622 0-1.042-.133-2.052-.382-3.016z" />
                        </svg>
                    </div>
                    <h4 class="text-2xl font-black">Verified Only</h4>
                    <p class="text-gray-500 font-medium leading-relaxed">Our custom tracking system verifies every
                        single member. No bots, no fake accounts, no wasted budget.</p>
                </div>

                <div class="glass-card p-12 rounded-[2.5rem] space-y-6 hover-glow transition-all">
                    <div
                        class="w-12 h-12 bg-purple-500/10 rounded-xl flex items-center justify-center border border-purple-500/20">
                        <svg class="w-6 h-6 text-purple-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1M21 12a9 9 0 11-18 0 9 9 0 0118 0z" />
                        </svg>
                    </div>
                    <h4 class="text-2xl font-black">Secure Escrow</h4>
                    <p class="text-gray-500 font-medium leading-relaxed">Funds are held securely in our system and only
                        released to promoters when growth is 100% verified.</p>
                </div>

                <div class="glass-card p-12 rounded-[2.5rem] space-y-6 hover-glow transition-all">
                    <div
                        class="w-12 h-12 bg-[#D4AF37]/10 rounded-xl flex items-center justify-center border border-[#D4AF37]/20">
                        <svg class="w-6 h-6 text-[#D4AF37]" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M13 10V3L4 14h7v7l9-11h-7z" />
                        </svg>
                    </div>
                    <h4 class="text-2xl font-black">Fast Payouts</h4>
                    <p class="text-gray-500 font-medium leading-relaxed">Withdraw your earnings directly to your bank
                        account with one click. Most payouts are processed instantly.</p>
                </div>
            </div>
        </section>

        <!-- Final CTA -->
        <section class="py-32 px-6 text-center max-w-4xl mx-auto space-y-12">
            <h2 class="text-4xl md:text-7xl font-black tracking-tight leading-tight">Ready to start your growth journey?
            </h2>
            <div class="flex flex-wrap justify-center gap-6">
                <a href="<?php echo e(route('register')); ?>"
                    class="v2-gradient px-12 py-5 rounded-full text-white font-black text-xs uppercase tracking-widest shadow-2xl gold-glow hover:scale-110 transition-all">
                    Register Now
                </a>
                <a href="<?php echo e(route('login')); ?>"
                    class="px-12 py-5 rounded-full bg-white/5 border border-white/10 text-white font-black text-xs uppercase tracking-widest hover:bg-white/10 transition-all">
                    Log in
                </a>
            </div>
        </section>
    </main>

    <?php echo $__env->make('layouts.footer', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
</body>

</html><?php /**PATH C:\Users\HP\Desktop\AWON SCRIPT\market\resources\views/welcome.blade.php ENDPATH**/ ?>