<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

    <title><?php echo e(config('app.name', 'Laravel')); ?></title>

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Outfit:wght@300;400;600;800;900&display=swap" rel="stylesheet">

    <!-- Scripts -->
    <?php echo app('Illuminate\Foundation\Vite')(['resources/css/app.css', 'resources/js/app.js']); ?>
    <style>
        body {
            font-family: 'Outfit', sans-serif;
            background-color: #020617;
            color: #f8fafc;
        }

        .hero-gradient {
            background: radial-gradient(circle at top left, rgba(30, 58, 138, 0.4) 0%, transparent 70%),
                radial-gradient(circle at bottom right, rgba(212, 175, 55, 0.08) 0%, transparent 70%);
        }

        .v2-gradient {
            background: linear-gradient(135deg, #1E3A8A 0%, #111827 100%);
        }

        .gold-glow {
            box-shadow: 0 0 50px -10px rgba(212, 175, 55, 0.15);
        }

        .glass-card {
            background: rgba(255, 255, 255, 0.02);
            backdrop-filter: blur(16px);
            border: 1px solid rgba(255, 255, 255, 0.08);
        }

        .hover-glow:hover {
            border-color: rgba(212, 175, 55, 0.3);
            background: rgba(255, 255, 255, 0.04);
            transform: translateY(-8px);
        }

        .accent-text {
            background: linear-gradient(to right, #D4AF37, #fde68a);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
        }
    </style>
</head>

<body class="font-sans antialiased selection:bg-[#D4AF37] selection:text-white">
    <div class="min-h-screen hero-gradient">
        <?php echo $__env->make('layouts.navigation', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

        <!-- Page Heading -->
        <?php if(isset($header)): ?>
            <header class="bg-[#020617]/50 backdrop-blur-xl border-b border-white/5">
                <div class="max-w-7xl mx-auto py-6 px-4 sm:px-6 lg:px-8">
                    <?php echo e($header); ?>

                </div>
            </header>
        <?php endif; ?>

        <!-- Page Content -->
        <main>
            <?php echo e($slot); ?>

        </main>

        <?php echo $__env->make('layouts.footer', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
    </div>
</body>

</html><?php /**PATH C:\Users\HP\Desktop\AWON SCRIPT\market\resources\views/layouts/app.blade.php ENDPATH**/ ?>