<?php if (isset($component)) { $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54 = $attributes; } ?>
<?php $component = App\View\Components\AppLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('app-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\AppLayout::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
     <?php $__env->slot('header', null, []); ?> 
        <div class="py-4">
            <h2 class="font-black text-4xl text-white tracking-tight">
                <?php echo e(__('Create')); ?> <span class="accent-text">New Campaign</span>
            </h2>
            <p class="text-gray-400 font-bold mt-2 uppercase tracking-widest text-[10px]">Launch your growth mission</p>
        </div>
     <?php $__env->endSlot(); ?>

    <div class="py-12">
        <div class="max-w-4xl mx-auto px-6">
            <div class="glass-card rounded-[3rem] p-10 border border-white/5">
                <form action="<?php echo e(route('campaigns.store')); ?>" method="POST" class="space-y-8">
                    <?php echo csrf_field(); ?>
                    <div>
                        <label for="title"
                            class="block text-[10px] font-black text-gray-400 uppercase tracking-widest mb-2 px-1">Campaign
                            Title</label>
                        <input type="text" name="title" id="title"
                            class="block w-full bg-white/5 border-white/10 rounded-2xl py-4 px-6 text-white placeholder-gray-500 focus:border-[#D4AF37] focus:ring-0 transition-all font-medium"
                            placeholder="e.g. Luxury Real Estate Group Expansion" required>
                    </div>

                    <div>
                        <label for="description"
                            class="block text-[10px] font-black text-gray-400 uppercase tracking-widest mb-2 px-1">Group
                            Description & Instructions</label>
                        <textarea name="description" id="description" rows="5"
                            class="block w-full bg-white/5 border-white/10 rounded-2xl py-4 px-6 text-white placeholder-gray-500 focus:border-[#D4AF37] focus:ring-0 transition-all font-medium"
                            placeholder="Tell promoters about your group and any special instructions..."
                            required></textarea>
                    </div>

                    <div>
                        <label for="whatsapp_link"
                            class="block text-[10px] font-black text-gray-400 uppercase tracking-widest mb-2 px-1">WhatsApp
                            Group Link</label>
                        <input type="url" name="whatsapp_link" id="whatsapp_link"
                            class="block w-full bg-white/5 border-white/10 rounded-2xl py-4 px-6 text-white placeholder-gray-500 focus:border-[#D4AF37] focus:ring-0 transition-all font-medium"
                            placeholder="https://chat.whatsapp.com/..." required>
                        <p class="text-[9px] font-black text-gray-500 uppercase tracking-widest mt-3 px-1">Note: This
                            link will only be shown to approved promoters with instructions.</p>
                    </div>

                    <div class="grid grid-cols-1 md:grid-cols-2 gap-8">
                        <div>
                            <label for="rate_per_member"
                                class="block text-[10px] font-black text-gray-400 uppercase tracking-widest mb-2 px-1">Rate
                                per New Member (₦)</label>
                            <input type="number" name="rate_per_member" id="rate_per_member" step="0.01"
                                class="block w-full bg-white/5 border-white/10 rounded-2xl py-4 px-6 text-white placeholder-gray-500 focus:border-[#D4AF37] focus:ring-0 transition-all font-medium tabular-nums"
                                required>
                        </div>
                        <div>
                            <label for="target_users"
                                class="block text-[10px] font-black text-gray-400 uppercase tracking-widest mb-2 px-1">Target
                                Number of Users</label>
                            <input type="number" name="target_users" id="target_users"
                                class="block w-full bg-white/5 border-white/10 rounded-2xl py-4 px-6 text-white placeholder-gray-500 focus:border-[#D4AF37] focus:ring-0 transition-all font-medium tabular-nums"
                                required>
                        </div>
                    </div>

                    <div class="bg-white/5 border border-white/5 p-8 rounded-[2rem] relative overflow-hidden group">
                        <div
                            class="absolute -right-8 -bottom-8 w-32 h-32 bg-indigo-600/10 rounded-full blur-3xl group-hover:bg-indigo-600/20 transition-all">
                        </div>
                        <div class="flex flex-col md:flex-row justify-between items-center gap-6 relative z-10">
                            <div>
                                <span
                                    class="block text-[10px] font-black text-indigo-400 uppercase tracking-widest mb-1">Total
                                    Campaign Cost</span>
                                <span class="text-3xl font-black text-white tracking-tighter tabular-nums">₦<span
                                        id="total_cost_display">0.00</span></span>
                            </div>
                            <div class="text-center md:text-right">
                                <span
                                    class="block text-[10px] font-black text-gray-500 uppercase tracking-widest mb-1">Your
                                    Wallet Balance</span>
                                <span
                                    class="text-xl font-black tabular-nums <?php echo e(auth()->user()->wallet->balance <= 0 ? 'text-red-500' : 'text-green-400'); ?>">
                                    ₦<?php echo e(number_format(auth()->user()->wallet->balance, 2)); ?>

                                </span>
                            </div>
                        </div>
                    </div>

                    <div class="flex items-center justify-end pt-4">
                        <button type="submit"
                            class="v2-gradient text-white px-12 py-4 rounded-full text-[10px] font-black uppercase tracking-widest hover:scale-105 transition-all duration-300 shadow-xl gold-glow">
                            Initialize Campaign
                        </button>
                    </div>
                </form>

                <script>
                    const rateInput = document.getElementById('rate_per_member');
                    const targetInput = document.getElementById('target_users');
                    const totalDisplay = document.getElementById('total_cost_display');

                    function calculateTotal() {
                        const rate = parseFloat(rateInput.value) || 0;
                        const target = parseInt(targetInput.value) || 0;
                        totalDisplay.innerText = (rate * target).toLocaleString(undefined, { minimumFractionDigits: 2, maximumFractionDigits: 2 });
                    }

                    rateInput.addEventListener('input', calculateTotal);
                    targetInput.addEventListener('input', calculateTotal);
                </script>
            </div>
        </div>
    </div>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $attributes = $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $component = $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?><?php /**PATH C:\Users\HP\Desktop\AWON SCRIPT\market\resources\views/campaigns/create.blade.php ENDPATH**/ ?>