<x-app-layout>
    <div class="min-h-screen bg-[#020617] py-12">
        <div class="max-w-5xl mx-auto px-4 sm:px-6 lg:px-8">

            @if(session('success'))
                <div
                    class="mb-8 p-6 bg-green-500/10 border border-green-500/20 rounded-[2rem] text-green-400 text-sm font-black uppercase tracking-widest animate-in fade-in slide-in-from-top duration-500 italic">
                    {{ session('success') }}
                </div>
            @endif

            @if(session('error'))
                <div
                    class="mb-8 p-6 bg-red-500/10 border border-red-500/20 rounded-[2rem] text-red-400 text-sm font-black uppercase tracking-widest animate-in fade-in slide-in-from-top duration-500 italic">
                    {{ session('error') }}
                </div>
            @endif

            <!-- Main Content Area -->
            <div class="space-y-12">

                <!-- Balance Hero Section -->
                <div class="glass-card rounded-[3.5rem] p-12 relative overflow-hidden group">
                    <div
                        class="absolute -right-20 -top-20 w-80 h-80 bg-[#D4AF37]/5 rounded-full blur-3xl group-hover:bg-[#D4AF37]/10 transition-all duration-700">
                    </div>
                    <div class="absolute -left-20 -bottom-20 w-60 h-60 bg-indigo-600/5 rounded-full blur-3xl"></div>

                    <div class="relative z-10 flex flex-col items-center justify-center text-center space-y-8">
                        <div class="space-y-2">
                            <span class="text-[10px] font-black text-[#D4AF37] uppercase tracking-[0.4em]">Available
                                Balance</span>
                            <div class="flex items-start justify-center">
                                <span class="text-3xl font-black text-gray-500 mt-3 mr-2">₦</span>
                                <span class="text-7xl md:text-8xl font-black text-white tabular-nums tracking-tighter">
                                    {{ number_format(auth()->user()->wallet->balance, 2) }}
                                </span>
                            </div>
                        </div>

                        </div>
                    </div>
                </div>

                <!-- Feature Grid -->
                <div class="grid grid-cols-1 md:grid-cols-3 gap-8">
                    <div
                        class="glass-card p-10 rounded-[3rem] border border-white/5 flex flex-col justify-between group hover:border-[#D4AF37]/20 transition-all duration-500">
                        <div
                            class="w-14 h-14 bg-white/5 rounded-2xl flex items-center justify-center text-[#D4AF37] mb-8 group-hover:scale-110 transition-transform duration-500">
                            <svg class="w-7 h-7" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                    d="M13 10V3L4 14h7v7l9-11h-7z" />
                            </svg>
                        </div>
                        <div>
                            <h4 class="font-black text-white text-xl mb-2 tracking-tight">Instant Deposits</h4>
                            <p
                                class="text-xs text-gray-400 leading-relaxed font-bold uppercase tracking-widest opacity-60">
                                Secure Transactions</p>
                        </div>
                    </div>

                    <div
                        class="glass-card p-10 rounded-[3rem] border border-white/5 flex flex-col justify-between group hover:border-indigo-500/20 transition-all duration-500">
                        <div
                            class="w-14 h-14 bg-white/5 rounded-2xl flex items-center justify-center text-indigo-400 mb-8 group-hover:scale-110 transition-transform duration-500">
                            <svg class="w-7 h-7" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                    d="M9 12l2 2 4-4m5.618-4.016A11.955 11.955 0 0112 2.944a11.955 11.955 0 01-8.618 3.040L3 9c0 5.591 3.824 10.29 9 11.622 5.176-1.332 9-6.03 9-11.622l-4.382-7.016z" />
                            </svg>
                        </div>
                        <div>
                            <h4 class="font-black text-white text-xl mb-2 tracking-tight">Secure & Encrypted</h4>
                            <p
                                class="text-xs text-gray-400 leading-relaxed font-bold uppercase tracking-widest opacity-60">
                                Bank-Grade Security</p>
                        </div>
                    </div>

                    <div
                        class="glass-card p-10 rounded-[3rem] border border-white/5 flex flex-col justify-between group hover:border-[#D4AF37]/20 transition-all duration-500">
                        <div
                            class="w-14 h-14 bg-white/5 rounded-2xl flex items-center justify-center text-[#D4AF37] mb-8 group-hover:scale-110 transition-transform duration-500">
                            <svg class="w-7 h-7" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                    d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.59.1M12 12v4" />
                            </svg>
                        </div>
                        <div>
                            <h4 class="font-black text-white text-xl mb-2 tracking-tight">Fast Processing</h4>
                            <p
                                class="text-xs text-gray-400 leading-relaxed font-bold uppercase tracking-widest opacity-60">
                                Quick Withdrawals</p>
                        </div>
                    </div>
                </div>

                <!-- Transaction History -->
                <div class="space-y-8">
                    <div class="flex items-center justify-between px-6">
                        <h3 class="font-black text-2xl text-white tracking-tight italic">Transaction <span
                                class="accent-text">History</span></h3>
                        <a href="#"
                            class="text-[10px] font-black text-gray-500 hover:text-white transition-colors uppercase tracking-[0.2em]">View
                            All</a>
                    </div>

                    <div class="glass-card rounded-[3rem] border border-white/5 overflow-hidden">
                        <div class="divide-y divide-white/5">
                            @forelse($transactions as $tx)
                                <div
                                    class="px-10 py-8 hover:bg-white/[0.02] transition-all duration-300 flex items-center justify-between group">
                                    <div class="flex items-center gap-8">
                                        <div @class([
                                            'w-16 h-16 rounded-2xl flex items-center justify-center transition-all duration-500 shadow-lg',
                                            'bg-green-500/10 text-green-400 group-hover:bg-green-500 group-hover:text-white' => in_array($tx->type, ['deposit', 'earning']),
                                            'bg-red-500/10 text-red-400 group-hover:bg-red-500 group-hover:text-white' => !in_array($tx->type, ['deposit', 'earning']),
                                        ])>
                                            @if(in_array($tx->type, ['deposit', 'earning']))
                                                <svg class="w-7 h-7" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2.5"
                                                        d="M16 17l-4 4m0 0l-4-4m4 4V3" />
                                                </svg>
                                            @else
                                                <svg class="w-7 h-7" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2.5"
                                                        d="M8 7l4-4m0 0l4 4m-4-4v18" />
                                                </svg>
                                            @endif
                                        </div>
                                        <div>
                                            <p class="font-black text-white text-xl tracking-tight">{{ $tx->description }}
                                            </p>
                                            <div class="flex items-center gap-3 mt-1.5">
                                                <span
                                                    class="text-[10px] font-black text-gray-500 uppercase tracking-widest">{{ $tx->created_at->format('M d, Y') }}</span>
                                                <span class="w-1 h-1 bg-white/10 rounded-full"></span>
                                                <span @class([
                                                    'text-[10px] font-black uppercase tracking-widest px-2 py-0.5 rounded-md',
                                                    'bg-green-500/10 text-green-400' => in_array($tx->type, ['deposit', 'earning']),
                                                    'bg-red-500/10 text-red-400' => !in_array($tx->type, ['deposit', 'earning']),
                                                ])>
                                                    {{ str_replace('_', ' ', $tx->type) }}
                                                </span>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="text-right">
                                        <p @class([
                                            'text-2xl font-black tabular-nums tracking-tighter',
                                            'text-green-400' => in_array($tx->type, ['deposit', 'earning']),
                                            'text-red-400' => !in_array($tx->type, ['deposit', 'earning']),
                                        ])>
                                            {{ in_array($tx->type, ['deposit', 'earning']) ? '+' : '-' }}₦{{ number_format($tx->amount, 2) }}
                                        </p>
                                        <div class="flex items-center justify-end gap-2 mt-1">
                                            <div class="w-1.5 h-1.5 bg-green-500 rounded-full animate-pulse"></div>
                                            <p
                                                class="text-[9px] font-black text-gray-500 uppercase tracking-[0.2em] italic">
                                                CONFIRMED</p>
                                        </div>
                                    </div>
                                </div>
                            @empty
                                <div class="px-8 py-32 text-center">
                                    <div
                                        class="w-28 h-28 bg-white/5 rounded-full flex items-center justify-center mx-auto mb-8 text-gray-600 border border-white/5">
                                        <svg class="w-12 h-12 opacity-20" fill="none" stroke="currentColor"
                                            viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5"
                                                d="M20 12H4" />
                                        </svg>
                                    </div>
                                    <h5 class="text-white font-black text-2xl mb-3 tracking-tight">No Transactions Found
                                    </h5>
                                    <p
                                        class="text-gray-500 font-bold text-sm max-w-xs mx-auto uppercase tracking-widest text-[10px]">
                                        You have no transactions yet.</p>
                                </div>
                            @endforelse
                        </div>
                    </div>

                    @if($transactions->hasPages())
                        <div class="mt-8">
                            {{ $transactions->links() }}
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>

    <!-- Redesigned Fund Modal -->
    <div id="fund-modal"
        class="fixed inset-0 bg-black/80 backdrop-blur-2xl flex items-center justify-center hidden z-50 p-6 transition-all duration-500">
        <div
            class="glass-card rounded-[3.5rem] p-12 max-w-lg w-full transform animate-in fade-in zoom-in duration-300 border border-white/10 relative overflow-hidden">
            <div class="absolute -right-20 -top-20 w-60 h-60 bg-indigo-600/10 rounded-full blur-3xl"></div>

            <div class="flex justify-between items-start mb-12 relative z-10">
                <div class="space-y-1">
                    <h3 class="text-4xl font-black text-white tracking-tight italic">Fund <span
                            class="accent-text">Wallet</span></h3>
                    <p class="text-gray-400 font-bold text-xs uppercase tracking-widest">Secure Payment</p>
                </div>
                <button onclick="document.getElementById('fund-modal').classList.add('hidden')"
                    class="w-12 h-12 flex items-center justify-center bg-white/5 rounded-full hover:bg-white/10 transition-colors border border-white/10 group">
                    <svg class="w-6 h-6 text-gray-500 group-hover:text-white transition-colors" fill="none"
                        stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2.5"
                            d="M6 18L18 6M6 6l12 12" />
                    </svg>
                </button>
            </div>

            <form action="{{ route('wallet.fund') }}" method="POST" class="relative z-10">
                @csrf
                <div class="space-y-10 mb-12">
                    <div>
                        <label
                            class="text-[10px] font-black text-[#D4AF37] uppercase tracking-[0.4em] ml-4">Amount</label>
                        <div class="relative mt-4">
                            <span
                                class="absolute left-8 top-1/2 -translate-y-1/2 text-4xl font-black text-gray-600 italic">₦</span>
                            <input type="number" name="amount" min="100"
                                class="w-full pl-20 pr-10 py-8 bg-white/5 border border-white/10 focus:border-[#D4AF37] focus:ring-0 rounded-[2.5rem] text-5xl font-black text-white transition-all outline-none tabular-nums placeholder-gray-800"
                                placeholder="00.00" required autofocus>
                        </div>
                        <div class="mt-6 flex items-center gap-3 ml-6 opacity-60">
                            <div class="w-2 h-2 bg-[#D4AF37] rounded-full animate-pulse"></div>
                            <p class="text-[10px] font-black text-gray-400 uppercase tracking-[0.2em]">Min Deposit:
                                ₦100.00</p>
                        </div>
                    </div>
                </div>

                <div class="space-y-6">
                    <button type="submit"
                        class="w-full py-8 v2-gradient text-white rounded-[2.5rem] font-black text-xs uppercase tracking-[0.3em] shadow-2xl gold-glow hover:scale-[1.02] active:scale-95 transition-all duration-300">
                        Pay Now
                    </button>
                    <button type="button" onclick="document.getElementById('fund-modal').classList.add('hidden')"
                        class="w-full py-4 text-gray-600 font-black hover:text-white transition-colors text-[9px] uppercase tracking-[0.3em]">
                        Cancel
                    </button>
                </div>
            </form>

            <div
                class="mt-12 flex items-center justify-center gap-10 opacity-30 grayscale hover:opacity-100 hover:grayscale-0 transition-all duration-700">
                <img src="https://upload.wikimedia.org/wikipedia/commons/b/b7/MasterCard_Logo.svg" class="h-6"
                    alt="Mastercard">
                <img src="https://upload.wikimedia.org/wikipedia/commons/0/04/Visa.svg" class="h-4" alt="Visa">
                <img src="https://paystack.com/assets/img/login/paystack-logo.png" class="h-5" alt="Paystack">
            </div>
        </div>
    </div>
</x-app-layout>