<x-app-layout>
    <div class="min-h-screen bg-[#020617] py-12">
        <div class="max-w-5xl mx-auto px-4 sm:px-6 lg:px-8">

            <div class="space-y-12">
                <!-- Header Stats -->
                <div class="grid grid-cols-1 md:grid-cols-3 gap-8">
                    <div class="glass-card p-10 rounded-[3rem] border border-white/5 relative overflow-hidden group">
                        <div
                            class="absolute -right-10 -top-10 w-32 h-32 bg-indigo-600/5 rounded-full blur-2xl group-hover:bg-indigo-600/10 transition-all">
                        </div>
                        <span class="text-[10px] font-black text-gray-500 uppercase tracking-[0.4em] italic">Total
                            Submissions</span>
                        <p class="text-5xl font-black text-white mt-4 tracking-tighter tabular-nums">
                            {{ $submissions->total() }}
                        </p>
                    </div>
                    <div class="glass-card p-10 rounded-[3rem] border border-white/5 relative overflow-hidden group">
                        <div
                            class="absolute -right-10 -top-10 w-32 h-32 bg-[#D4AF37]/5 rounded-full blur-2xl group-hover:bg-[#D4AF37]/10 transition-all">
                        </div>
                        <span
                            class="text-[10px] font-black text-[#D4AF37] uppercase tracking-[0.4em] italic">Pending</span>
                        <p class="text-5xl font-black text-white mt-4 tracking-tighter tabular-nums">
                            {{ $submissions->where('status', 'pending')->count() }}
                        </p>
                    </div>
                    <div class="glass-card p-10 rounded-[3rem] border border-white/5 relative overflow-hidden group">
                        <div
                            class="absolute -right-10 -top-10 w-32 h-32 bg-green-500/5 rounded-full blur-2xl group-hover:bg-green-500/10 transition-all">
                        </div>
                        <span
                            class="text-[10px] font-black text-green-500 uppercase tracking-[0.4em] italic">Approved</span>
                        <p class="text-5xl font-black text-white mt-4 tracking-tighter tabular-nums">
                            {{ $submissions->where('status', 'approved')->count() }}
                        </p>
                    </div>
                </div>

                <!-- Submissions List -->
                <div class="space-y-8">
                    <div class="flex items-center justify-between px-6">
                        <h3 class="font-black text-2xl text-white tracking-tight italic">My <span
                                class="accent-text">Submissions</span></h3>
                        <p class="text-[10px] font-black text-gray-500 uppercase tracking-[0.2em] italic">Submission
                            History</p>
                    </div>

                    <div class="glass-card rounded-[3.5rem] border border-white/5 overflow-hidden">
                        <div class="overflow-x-auto">
                            <table class="min-w-full">
                                <thead>
                                    <tr class="bg-black/20">
                                        <th
                                            class="px-10 py-5 text-left text-[10px] font-black text-white uppercase tracking-[0.2em]">
                                            Campaign</th>
                                        <th
                                            class="px-10 py-5 text-left text-[10px] font-black text-white uppercase tracking-[0.2em]">
                                            Date</th>
                                        <th
                                            class="px-10 py-5 text-left text-[10px] font-black text-white uppercase tracking-[0.2em]">
                                            Status</th>
                                        <th
                                            class="px-10 py-5 text-left text-[10px] font-black text-white uppercase tracking-[0.2em]">
                                            Members</th>
                                        <th
                                            class="px-10 py-5 text-left text-[10px] font-black text-white uppercase tracking-[0.2em]">
                                            Earnings</th>
                                        <th
                                            class="px-10 py-5 text-right text-[10px] font-black text-white uppercase tracking-[0.2em]">
                                            Proof</th>
                                    </tr>
                                </thead>
                                <tbody class="divide-y divide-white/5">
                                    @forelse($submissions as $submission)
                                        <tr class="hover:bg-white/5 transition-colors group">
                                            <td class="px-10 py-6">
                                                <p
                                                    class="text-sm font-black text-white tracking-tight group-hover:text-[#D4AF37] transition-colors">
                                                    {{ $submission->campaign->title }}
                                                </p>
                                                @if ($submission->status === 'rejected' && $submission->admin_comment)
                                                    <p class="text-[9px] text-red-400 mt-1 font-bold">
                                                        {{ $submission->admin_comment }}
                                                    </p>
                                                @endif
                                            </td>
                                            <td class="px-10 py-6">
                                                <span
                                                    class="text-[10px] font-bold text-gray-500 uppercase">{{ $submission->created_at->format('M d, Y') }}</span>
                                            </td>
                                            <td class="px-10 py-6">
                                                <span @class([
                                                    'text-[9px] font-black uppercase tracking-[0.2em] px-3 py-1 rounded-full border italic shadow-sm',
                                                    'bg-yellow-500/10 text-yellow-400 border-yellow-500/20' =>
                                                        $submission->status === 'pending',
                                                    'bg-green-500/10 text-green-400 border-green-500/20' =>
                                                        $submission->status === 'approved',
                                                    'bg-red-500/10 text-red-500 border-red-500/20' =>
                                                        $submission->status === 'rejected',
                                                ])>{{ $submission->status }}</span>
                                            </td>
                                            <td class="px-10 py-6">
                                                <span
                                                    class="text-sm font-black text-white tabular-nums">{{ number_format($submission->member_growth) }}</span>
                                            </td>
                                            <td class="px-10 py-6">
                                                <span
                                                    class="text-sm font-black text-[#D4AF37] tabular-nums">₦{{ number_format($submission->member_growth * $submission->campaign->rate_per_member, 2) }}</span>
                                            </td>
                                            <td class="px-10 py-6 text-right">
                                                <a href="{{ Storage::url($submission->screenshot_path) }}" target="_blank"
                                                    class="text-[10px] font-black text-[#D4AF37] hover:text-white uppercase tracking-widest transition-colors border border-[#D4AF37]/30 px-6 py-2 rounded-full hover:bg-[#D4AF37]">
                                                    View
                                                </a>
                                            </td>
                                        </tr>
                                    @empty
                                        <tr>
                                            <td colspan="6" class="px-10 py-32 text-center">
                                                <div
                                                    class="w-32 h-32 bg-white/5 rounded-[2.5rem] flex items-center justify-center mx-auto mb-10 text-gray-600 border border-white/5">
                                                    <svg class="w-16 h-16 opacity-20" fill="none" stroke="currentColor"
                                                        viewBox="0 0 24 24">
                                                        <path stroke-linecap="round" stroke-linejoin="round"
                                                            stroke-width="1.5" d="M12 4v16m8-8H4" />
                                                    </svg>
                                                </div>
                                                <h5 class="text-white font-black text-3xl mb-4 tracking-tight italic">No
                                                    Submissions
                                                </h5>
                                                <p
                                                    class="text-gray-500 font-black text-[10px] uppercase tracking-[0.3em] max-w-sm mx-auto leading-relaxed italic">
                                                    You haven't submitted any proofs yet.</p>
                                                <a href="{{ route('campaigns.browse') }}"
                                                    class="inline-block mt-12 px-12 py-5 v2-gradient text-white rounded-full font-black text-[10px] uppercase tracking-[0.3em] shadow-2xl gold-glow hover:scale-105 transition-all duration-300">
                                                    Browse Campaigns
                                                </a>
                                            </td>
                                        </tr>
                                    @endforelse
                                </tbody>
                            </table>
                        </div>

                    </div>

                    @if($submissions->hasPages())
                        <div class="px-10 py-12 bg-white/[0.01] border-t border-white/5">
                            {{ $submissions->links() }}
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
    </div>
</x-app-layout>