<nav x-data="{ open: false }" class="bg-[#020617]/80 backdrop-blur-xl border-b border-white/5 sticky top-0 z-50">
    <!-- Primary Navigation Menu -->
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="flex justify-between h-20">
            <div class="flex">
                <!-- Logo -->
                <div class="shrink-0 flex items-center">
                    <a href="{{ route('dashboard') }}" class="flex items-center gap-3">
                        <div
                            class="w-10 h-10 bg-indigo-950 rounded-xl flex items-center justify-center border border-white/10 shadow-lg">
                            <svg class="w-6 h-6 text-[#D4AF37]" fill="currentColor" viewBox="0 0 24 24">
                                <path d="M12 2L2 7l10 5 10-5-10-5zM2 17l10 5 10-5M2 12l10 5 10-5" />
                            </svg>
                        </div>
                        <span class="text-xl font-black tracking-tight text-white">WhatsApp<span
                                class="text-[#D4AF37]">Grow</span></span>
                    </a>
                </div>

                <!-- Navigation Links -->
                <div class="hidden space-x-8 sm:-my-px sm:ms-10 sm:flex">
                    <x-nav-link :href="route('dashboard')" :active="request()->routeIs('dashboard')"
                        class="text-[10px] font-black uppercase tracking-widest">
                        {{ __('Dashboard') }}
                    </x-nav-link>

                    @if(Auth::user()->isBrand())
                        <x-nav-link :href="route('campaigns.index')" :active="request()->routeIs('campaigns.index')"
                            class="text-[10px] font-black uppercase tracking-widest">
                            {{ __('My Campaigns') }}
                        </x-nav-link>
                        <x-nav-link :href="route('wallet.index')" :active="request()->routeIs('wallet.index')"
                            class="text-[10px] font-black uppercase tracking-widest">
                            {{ __('My Wallet') }}
                        </x-nav-link>
                    @elseif(Auth::user()->isPromoter())
                        <x-nav-link :href="route('campaigns.browse')" :active="request()->routeIs('campaigns.browse')"
                            class="text-[10px] font-black uppercase tracking-widest">
                            {{ __('Browse Campaigns') }}
                        </x-nav-link>
                        <x-nav-link :href="route('submissions.my')" :active="request()->routeIs('submissions.my')"
                            class="text-[10px] font-black uppercase tracking-widest">
                            {{ __('My Submissions') }}
                        </x-nav-link>
                        <x-nav-link :href="route('wallet.index')" :active="request()->routeIs('wallet.index')"
                            class="text-[10px] font-black uppercase tracking-widest">
                            {{ __('Wallet') }}
                        </x-nav-link>
                    @elseif(Auth::user()->isAdmin())
                        <x-nav-link :href="route('admin.submissions.index')"
                            :active="request()->routeIs('admin.submissions.index')"
                            class="text-[10px] font-black uppercase tracking-widest">
                            {{ __('Review Queue') }}
                        </x-nav-link>
                        <x-nav-link :href="route('admin.campaigns.index')"
                            :active="request()->routeIs('admin.campaigns.index')"
                            class="text-[10px] font-black uppercase tracking-widest">
                            {{ __('Campaigns') }}
                        </x-nav-link>
                        <x-nav-link :href="route('admin.users.index')" :active="request()->routeIs('admin.users.index')"
                            class="text-[10px] font-black uppercase tracking-widest">
                            {{ __('Users') }}
                        </x-nav-link>
                    @endif
                </div>
            </div>

            <!-- Settings Dropdown -->
            <div class="hidden sm:flex sm:items-center sm:ms-6">
                <x-dropdown align="right" width="48">
                    <x-slot name="trigger">
                        <button
                            class="inline-flex items-center px-4 py-2 border border-white/5 text-[10px] font-black uppercase tracking-widest rounded-full text-gray-400 bg-white/5 hover:text-white hover:bg-white/10 transition duration-150 ease-in-out">
                            <div>{{ Auth::user()->name }}</div>
                            <div class="ms-1">
                                <svg class="fill-current h-4 w-4" xmlns="http://www.w3.org/2000/svg"
                                    viewBox="0 0 20 20">
                                    <path fill-rule="evenodd"
                                        d="M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414z"
                                        clip-rule="evenodd" />
                                </svg>
                            </div>
                        </button>
                    </x-slot>

                    <x-slot name="content">
                        <x-dropdown-link :href="route('profile.edit')">
                            {{ __('Profile') }}
                        </x-dropdown-link>

                        <!-- Authentication -->
                        <form method="POST" action="{{ route('logout') }}">
                            @csrf
                            <x-dropdown-link :href="route('logout')"
                                onclick="event.preventDefault(); this.closest('form').submit();">
                                {{ __('Log Out') }}
                            </x-dropdown-link>
                        </form>
                    </x-slot>
                </x-dropdown>
            </div>

            <!-- Hamburger -->
            <div class="-me-2 flex items-center sm:hidden">
                <button @click="open = ! open"
                    class="inline-flex items-center justify-center p-2 rounded-xl text-gray-400 hover:text-white hover:bg-white/5 focus:outline-none transition duration-150 ease-in-out">
                    <svg class="h-6 w-6" stroke="currentColor" fill="none" viewBox="0 0 24 24">
                        <path :class="{'hidden': open, 'inline-flex': ! open }" class="inline-flex"
                            stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M4 6h16M4 12h16M4 18h16" />
                        <path :class="{'hidden': ! open, 'inline-flex': open }" class="hidden" stroke-linecap="round"
                            stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12" />
                    </svg>
                </button>
            </div>
        </div>
    </div>

    <!-- Responsive Navigation Menu -->
    <div :class="{'block': open, 'hidden': ! open}" class="hidden sm:hidden bg-[#020617] border-b border-white/5">
        <div class="pt-2 pb-3 space-y-1">
            <x-responsive-nav-link :href="route('dashboard')" :active="request()->routeIs('dashboard')">
                {{ __('Dashboard') }}
            </x-responsive-nav-link>

            @if(Auth::user()->isPromoter())
                <x-responsive-nav-link :href="route('campaigns.browse')" :active="request()->routeIs('campaigns.browse')">
                    {{ __('Browse Campaigns') }}
                </x-responsive-nav-link>
                <x-responsive-nav-link :href="route('submissions.my')" :active="request()->routeIs('submissions.my')">
                    {{ __('My Submissions') }}
                </x-responsive-nav-link>
            @endif
        </div>

        <!-- Responsive Settings Options -->
        <div class="pt-4 pb-1 border-t border-white/5">
            <div class="px-4">
                <div class="font-black text-base text-white uppercase tracking-wider">{{ Auth::user()->name }}</div>
                <div class="font-medium text-sm text-gray-400">{{ Auth::user()->email }}</div>
            </div>

            <div class="mt-3 space-y-1">
                <x-responsive-nav-link :href="route('profile.edit')">
                    {{ __('Profile') }}
                </x-responsive-nav-link>

                <!-- Authentication -->
                <form method="POST" action="{{ route('logout') }}">
                    @csrf
                    <x-responsive-nav-link :href="route('logout')"
                        onclick="event.preventDefault(); this.closest('form').submit();">
                        {{ __('Log Out') }}
                    </x-responsive-nav-link>
                </form>
            </div>
        </div>
    </div>
</nav>