<x-app-layout>
    <x-slot name="header">
        <div class="flex justify-between items-center py-4">
            <h2 class="font-black text-4xl text-white tracking-tight">
                {{ $campaign->title }}
            </h2>
            <div class="flex gap-3">
                @if(auth()->user()->isBrand())
                    <span
                        class="px-6 py-2 bg-white/5 border border-white/10 text-white rounded-full text-[10px] font-black uppercase tracking-widest">{{ ucfirst($campaign->status) }}</span>
                @else
                    @if($campaign->promoters()->where('promoter_id', auth()->id())->exists())
                        <span
                            class="px-6 py-2 bg-green-500/10 border border-green-500/20 text-green-400 rounded-full text-[10px] font-black uppercase tracking-widest shadow-lg shadow-green-500/5">Joined</span>
                    @endif
                @endif
            </div>
        </div>
    </x-slot>

    <div class="py-12">
        <div class="max-w-4xl mx-auto px-6 space-y-10">
            <!-- Description Card -->
            <div class="glass-card rounded-[3rem] p-10 border border-white/5 relative overflow-hidden group">
                <div
                    class="absolute -right-8 -bottom-8 w-32 h-32 bg-[#D4AF37]/5 rounded-full blur-3xl group-hover:bg-[#D4AF37]/10 transition-all">
                </div>
                <h3
                    class="text-[10px] font-black text-gray-400 uppercase tracking-[0.3em] mb-6 border-b border-white/5 pb-4">
                    Description & Instructions</h3>
                <div class="prose max-w-none text-gray-300 font-medium leading-relaxed relative z-10">
                    {!! nl2br(e($campaign->description)) !!}
                </div>
            </div>

            <!-- Promoter Action Area -->
            @if(auth()->user()->isPromoter() && $campaign->promoters()->where('promoter_id', auth()->id())->exists())
                <div
                    class="glass-card p-10 rounded-[3rem] border border-white/5 bg-gradient-to-br from-indigo-600/10 to-transparent hover-glow transition-all">
                    <div class="flex flex-col md:flex-row justify-between items-center gap-10">
                        <div class="text-center md:text-left">
                            <span
                                class="text-[10px] font-black text-indigo-400 uppercase tracking-widest mb-2 block">Premium
                                Earning Opportunity</span>
                            <h3 class="text-3xl font-black text-white tracking-tight">Ready to <span
                                    class="accent-text">launch?</span></h3>
                            <p class="text-gray-400 font-bold mt-2">
                                Earn <span
                                    class="text-white bg-indigo-600/30 px-3 py-1 rounded-full border border-indigo-500/30 font-black tracking-tight mx-1">₦{{ number_format($campaign->rate_per_member, 2) }}</span>
                                per verified member join.
                            </p>
                        </div>
                        <div class="flex flex-wrap justify-center gap-6">
                            <a href="{{ $campaign->random_whatsapp_link }}" target="_blank"
                                class="inline-flex items-center px-10 py-4 bg-green-500/20 text-green-400 border border-green-500/30 rounded-full hover:bg-green-500 hover:text-white transition-all duration-500 font-black text-[10px] uppercase tracking-widest shadow-xl shadow-green-500/5">
                                <svg class="w-4 h-4 mr-2" fill="currentColor" viewBox="0 0 24 24">
                                    <path
                                        d="M12.031 6.172c-3.181 0-5.767 2.586-5.768 5.766-.001 1.298.38 2.27 1.025 3.207l-.634 2.316 2.368-.619c.895.485 1.889.742 2.998.742 3.181 0 5.767-2.586 5.768-5.766 0-3.18-2.585-5.746-5.757-5.746zm3.43 8.3c-.147.412-.733.784-1.025.823-.284.053-.534.053-.82.053s-.54-.047-.852-.1c-.341-.059-.727-.156-1.127-.323-1.637-.684-2.705-2.333-2.784-2.437s-.644-.853-.644-1.625c0-.771.404-1.15.547-1.306.147-.156.32-.234.426-.234s.213 0 .307.013c.107.013.24.013.373.333.147.36.507 1.224.547 1.32.04.093.067.2.013.307-.053.111-.08.187-.16.28l-.24.28c-.08.093-.16.187-.067.347.094.16.416.684.894 1.114.613.547 1.12.72 1.28.8s.267.067.36.013c.093-.053.4-1.227.507-1.32s.227-.08.333-.04c.107.04.68.32 1.147.547.467.227.707.333.773.453.067.12.067.68-.08 1.093z" />
                                </svg>
                                Join WhatsApp
                            </a>
                            <a href="#submit-proof"
                                class="inline-flex items-center px-10 py-4 v2-gradient text-white rounded-full hover:scale-105 transition-all duration-300 font-black text-[10px] uppercase tracking-widest shadow-xl gold-glow">
                                Submit Proof
                            </a>
                        </div>
                    </div>
                </div>

                <!-- Proof Form -->
                <div id="submit-proof"
                    class="glass-card rounded-[3rem] p-10 border border-white/5 scroll-mt-10 overflow-hidden relative group">
                    <div
                        class="absolute -left-8 -top-8 w-32 h-32 bg-indigo-600/5 rounded-full blur-3xl group-hover:bg-indigo-600/10 transition-all">
                    </div>
                    <h3
                        class="text-[10px] font-black text-gray-400 uppercase tracking-[0.3em] mb-8 border-b border-white/5 pb-4 relative z-10">
                        Submit Growth Proof</h3>

                    @if ($errors->any())
                        <div class="mb-6 bg-red-500/10 border border-red-500/20 rounded-2xl p-4">
                            <ul class="list-disc list-inside text-[10px] font-bold text-red-400 uppercase tracking-widest">
                                @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif

                    @if (session('success'))
                        <div
                            class="mb-6 bg-green-500/10 border border-green-500/20 rounded-2xl p-4 text-[10px] font-bold text-green-400 uppercase tracking-widest">
                            {{ session('success') }}
                        </div>
                    @endif

                    @if (session('error'))
                        <div
                            class="mb-6 bg-red-500/10 border border-red-500/20 rounded-2xl p-4 text-[10px] font-bold text-red-400 uppercase tracking-widest">
                            {{ session('error') }}
                        </div>
                    @endif
                    <form action="{{ route('proof.submit', $campaign) }}" method="POST" enctype="multipart/form-data"
                        class="space-y-8 relative z-10">
                        @csrf
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-8">
                            <div>
                                <label
                                    class="block text-[10px] font-black text-gray-500 uppercase tracking-widest mb-3 px-1">Proof
                                    Screenshots</label>
                                <div class="relative group cursor-pointer">
                                    <input type="file" name="screenshot" id="screenshot"
                                        class="absolute inset-0 w-full h-full opacity-0 cursor-pointer z-20" required
                                        onchange="updateFileName(this)">
                                    <div
                                        class="bg-white/5 border border-dashed border-white/20 rounded-2xl p-8 flex flex-col items-center justify-center group-hover:bg-white/10 group-hover:border-[#D4AF37]/50 transition-all duration-300 relative z-10">
                                        <div
                                            class="w-12 h-12 bg-white/5 rounded-full flex items-center justify-center mb-4 group-hover:scale-110 transition-transform">
                                            <svg class="w-6 h-6 text-gray-400 group-hover:text-[#D4AF37] transition-colors"
                                                fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                    d="M4 16v1a3 3 0 003 3h10a3 3 0 003-3v-1m-4-8l-4-4m0 0L8 8m4-4v12" />
                                            </svg>
                                        </div>
                                        <p class="text-xs font-black text-white uppercase tracking-widest mb-2">Upload
                                            Screenshot</p>
                                        <p id="file-name"
                                            class="text-[10px] font-bold text-gray-500 uppercase tracking-widest text-center">
                                            Click to browse</p>
                                    </div>
                                </div>
                                <script>
                                    function updateFileName(input) {
                                        const fileName = input.files[0] ? input.files[0].name : 'Click to browse';
                                        document.getElementById('file-name').textContent = fileName;
                                    }
                                </script>
                                <p class="text-[9px] font-bold text-gray-500 uppercase tracking-widest mt-3 px-1">
                                    Before/After or current member count</p>
                            </div>
                            <div>
                                <label
                                    class="block text-[10px] font-black text-gray-500 uppercase tracking-widest mb-3 px-1">Group
                                    Members</label>
                                <div class="relative">
                                    <input type="number" name="member_growth" id="member_growth"
                                        class="block w-full text-lg font-black text-white bg-white/5 border border-white/10 rounded-2xl px-6 py-3 focus:ring-0 focus:border-[#D4AF37] transition-all placeholder-gray-600"
                                        placeholder="e.g. 500" min="0" required oninput="calculateEarnings(this.value)">
                                </div>
                                <div
                                    class="mt-4 bg-indigo-600/10 border border-indigo-500/20 rounded-2xl p-4 flex items-center justify-between">
                                    <span class="text-[10px] font-black text-indigo-400 uppercase tracking-widest">Estimated
                                        Earning</span>
                                    <span class="text-xl font-black text-white tracking-tighter"
                                        id="estimated-earning">₦0.00</span>
                                </div>
                                <script>
                                    function calculateEarnings(members) {
                                        const rate = {{ $campaign->rate_per_member }};
                                        const total = members * rate;
                                        document.getElementById('estimated-earning').textContent = '₦' + total.toLocaleString('en-NG', {
                                            minimumFractionDigits: 2,
                                            maximumFractionDigits: 2
                                        });
                                    }
                                </script>
                                <p class="text-[9px] font-bold text-gray-500 uppercase tracking-widest mt-3 px-1">
                                    Current member count in your group</p>
                            </div>
                        </div>
                        <div class="flex justify-end pt-4">
                            <button type="submit"
                                class="px-12 py-4 bg-white/5 border border-white/10 text-white rounded-full hover:bg-white/10 hover:border-[#D4AF37]/30 transition-all font-black text-[10px] uppercase tracking-widest">
                                Submit for Review
                            </button>
                        </div>
                    </form>
                </div>
            @endif

            <!-- Brand Stats Area -->
            @if(auth()->user()->isBrand())
                <div class="glass-card p-10 rounded-[3rem] border border-white/5">
                    <h3
                        class="text-[10px] font-black text-gray-400 uppercase tracking-[0.3em] mb-10 border-b border-white/5 pb-4">
                        Performance Metrics</h3>
                    <div class="grid grid-cols-2 lg:grid-cols-4 gap-10">
                        <div class="group">
                            <p
                                class="text-[9px] font-black text-gray-500 uppercase tracking-widest mb-2 group-hover:text-indigo-400 transition-colors">
                                Campaign Rate</p>
                            <p class="text-3xl font-black text-white tabular-nums tracking-tighter">
                                ₦{{ number_format($campaign->rate_per_member, 2) }}</p>
                        </div>
                        <div class="group">
                            <p
                                class="text-[9px] font-black text-gray-500 uppercase tracking-widest mb-2 group-hover:text-[#D4AF37] transition-colors">
                                Total Submissions</p>
                            <p class="text-3xl font-black text-white tabular-nums tracking-tighter">
                                {{ $campaign->submissions()->count() }}
                            </p>
                        </div>
                    </div>
                </div>
            @endif
        </div>
    </div>
</x-app-layout>