<x-app-layout>
    <x-slot name="header">
        <div class="flex justify-between items-center py-4">
            <h2 class="font-black text-4xl text-white tracking-tight">
                {{ __('Brand') }} <span class="accent-text">Dashboard</span>
            </h2>
            <a href="{{ route('campaigns.create') }}"
                class="v2-gradient text-white px-8 py-3 rounded-full text-[10px] font-black uppercase tracking-widest hover:scale-105 transition-all duration-300 shadow-xl gold-glow flex items-center gap-2">
                <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2.5" d="M12 4v16m8-8H4" />
                </svg>
                Create Campaign</a>
        </div>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto px-6 space-y-12">
            <div class="grid grid-cols-1 md:grid-cols-2 gap-8">
                <div class="glass-card p-10 rounded-[2.5rem] hover-glow transition-all group relative overflow-hidden">
                    <div
                        class="absolute -right-8 -bottom-8 w-32 h-32 bg-indigo-600/10 rounded-full blur-3xl group-hover:bg-indigo-600/20 transition-all">
                    </div>
                    <div class="text-[10px] uppercase text-indigo-400 font-black tracking-[0.3em] mb-4">Active Campaigns
                    </div>
                    <div class="text-6xl font-black text-white tabular-nums tracking-tighter">
                        {{ $stats['active_campaigns'] }}</div>
                </div>
                <div class="glass-card p-10 rounded-[2.5rem] hover-glow transition-all group relative overflow-hidden">
                    <div
                        class="absolute -right-8 -bottom-8 w-32 h-32 bg-[#D4AF37]/10 rounded-full blur-3xl group-hover:bg-[#D4AF37]/20 transition-all">
                    </div>
                    <div class="text-[10px] uppercase text-[#D4AF37] font-black tracking-[0.3em] mb-4">Real Human Growth
                    </div>
                    <div class="text-6xl font-black text-white tabular-nums tracking-tighter">
                        {{ $stats['total_submissions'] }}</div>
                </div>
            </div>

            <div class="glass-card rounded-[3rem] overflow-hidden border border-white/5">
                <div class="p-10 border-b border-white/5 flex justify-between items-center bg-white/5">
                    <h3 class="text-xl font-black text-white tracking-tight">Your Recent <span
                            class="accent-text">Campaigns</span></h3>
                    <a href="{{ route('campaigns.index') }}"
                        class="text-[10px] font-black text-gray-400 hover:text-white uppercase tracking-widest transition-colors">Manage
                        All &rarr;</a>
                </div>
                <div class="overflow-x-auto">
                    <table class="min-w-full">
                        <thead>
                            <tr class="bg-black/20">
                                <th
                                    class="px-10 py-5 text-left text-[10px] font-black text-gray-500 uppercase tracking-[0.2em]">
                                    Campaign Title</th>
                                <th
                                    class="px-10 py-5 text-left text-[10px] font-black text-gray-500 uppercase tracking-[0.2em]">
                                    Status</th>
                                <th
                                    class="px-10 py-5 text-left text-[10px] font-black text-gray-500 uppercase tracking-[0.2em]">
                                    Rate</th>
                                <th
                                    class="px-10 py-5 text-right text-[10px] font-black text-gray-500 uppercase tracking-[0.2em]">
                                    Action</th>
                            </tr>
                        </thead>
                        <tbody class="divide-y divide-white/5">
                            @foreach($campaigns as $campaign)
                                <tr class="hover:bg-white/5 transition-colors">
                                    <td class="px-10 py-6">
                                        <p class="text-sm font-black text-white tracking-tight">{{ $campaign->title }}</p>
                                        <p class="text-[10px] font-bold text-gray-500 uppercase mt-1">Created
                                            {{ $campaign->created_at->format('M d, Y') }}</p>
                                    </td>
                                    <td class="px-10 py-6">
                                        <span @class([
                                            'px-4 py-1.5 rounded-full text-[9px] font-black uppercase tracking-widest',
                                            'bg-green-500/10 text-green-400 border border-green-500/20' => $campaign->status == 'active',
                                            'bg-yellow-500/10 text-yellow-400 border border-yellow-500/20' => $campaign->status == 'pending',
                                            'bg-blue-500/10 text-blue-400 border border-blue-500/20' => $campaign->status == 'completed',
                                        ])>
                                            {{ $campaign->status }}
                                        </span>
                                    </td>
                                    <td class="px-10 py-6">
                                        <span
                                            class="text-sm font-black text-white tabular-nums">₦{{ number_format($campaign->rate_per_member, 2) }}</span>
                                        <span class="text-[10px] font-bold text-gray-500">/ join</span>
                                    </td>
                                    <td class="px-10 py-6 text-right">
                                        <a href="{{ route('campaigns.show', $campaign) }}"
                                            class="text-[10px] font-black text-[#D4AF37] hover:text-white uppercase tracking-widest transition-colors border border-[#D4AF37]/30 px-6 py-2 rounded-full hover:bg-[#D4AF37]">Manage</a>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</x-app-layout>