<x-guest-layout>
    <div class="mb-10 lg:text-left">
        <h2 class="text-4xl md:text-5xl font-black text-white tracking-tight mb-3 italic">Reset <span
                class="accent-text">Password</span></h2>
        <p class="text-gray-400 font-bold text-base md:text-lg leading-relaxed uppercase tracking-widest text-[10px]">
            Create a new password</p>
    </div>

    <form method="POST" action="{{ route('password.store') }}" class="space-y-6">
        @csrf

        <!-- Password Reset Token -->
        <input type="hidden" name="token" value="{{ $request->route('token') }}">

        <!-- Email Address -->
        <div class="space-y-3">
            <label for="email" class="block text-[10px] font-black uppercase tracking-[0.3em] text-[#D4AF37] ml-2">Email
                Address</label>
            <input id="email"
                class="block w-full bg-white/5 border border-white/10 rounded-[1.5rem] py-5 px-8 text-white placeholder-gray-600 focus:bg-white/10 focus:ring-0 focus:border-[#D4AF37] transition-all outline-none font-medium opacity-60"
                type="email" name="email" :value="old('email', $request->email)" required readonly autofocus
                autocomplete="username" />
            <x-input-error :messages="$errors->get('email')" class="mt-2" />
        </div>

        <!-- Password -->
        <div class="space-y-3">
            <label for="password"
                class="block text-[10px] font-black uppercase tracking-[0.3em] text-[#D4AF37] ml-2">New Password</label>
            <div class="relative group/pass">
                <input id="password"
                    class="block w-full bg-white/5 border border-white/10 rounded-[1.5rem] py-5 px-8 text-white placeholder-gray-600 focus:bg-white/10 focus:ring-0 focus:border-[#D4AF37] transition-all outline-none pr-16 font-medium"
                    type="password" name="password" placeholder="At least 8 bits" required
                    autocomplete="new-password" />
                <button type="button" onclick="togglePassword('password', this)"
                    class="absolute right-6 top-1/2 -translate-y-1/2 p-2 text-gray-500 hover:text-[#D4AF37] transition-colors focus:outline-none">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M15 12a3 3 0 11-6 0 3 3 0 016 0z" />
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z" />
                    </svg>
                </button>
            </div>
            <x-input-error :messages="$errors->get('password')" class="mt-2" />
        </div>

        <!-- Confirm Password -->
        <div class="space-y-3">
            <label for="password_confirmation"
                class="block text-[10px] font-black uppercase tracking-[0.3em] text-[#D4AF37] ml-2">Confirm
                Password</label>
            <div class="relative group/pass">
                <input id="password_confirmation"
                    class="block w-full bg-white/5 border border-white/10 rounded-[1.5rem] py-5 px-8 text-white placeholder-gray-600 focus:bg-white/10 focus:ring-0 focus:border-[#D4AF37] transition-all outline-none pr-16 font-medium"
                    type="password" name="password_confirmation" placeholder="Confirm new secret" required
                    autocomplete="new-password" />
                <button type="button" onclick="togglePassword('password_confirmation', this)"
                    class="absolute right-6 top-1/2 -translate-y-1/2 p-2 text-gray-500 hover:text-[#D4AF37] transition-colors focus:outline-none">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M15 12a3 3 0 11-6 0 3 3 0 016 0z" />
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z" />
                    </svg>
                </button>
            </div>
            <x-input-error :messages="$errors->get('password_confirmation')" class="mt-2" />
        </div>

        <div class="pt-6">
            <button type="submit"
                class="w-full v2-gradient py-6 rounded-full text-white font-black uppercase tracking-[0.3em] text-[10px] shadow-2xl gold-glow hover:scale-[1.02] transition active:scale-95 group text-center">
                {{ __('Reset Password') }}
                <span class="inline-block ml-2 group-hover:translate-x-1 transition-transform">→</span>
            </button>
        </div>
    </form>
</x-guest-layout>