<x-guest-layout>
    <div class="mb-10 lg:text-left">
        <h2 class="text-4xl md:text-5xl font-black text-white tracking-tight mb-3 italic">Welcome <span
                class="accent-text">Back</span></h2>
        <p class="text-gray-400 font-bold text-base md:text-lg leading-relaxed uppercase tracking-widest text-[10px]">
            Log in to your account</p>
    </div>

    <!-- Session Status -->
    <x-auth-session-status class="mb-6" :status="session('status')" />

    <style>
        /* Hide browser default password toggles */
        input::-ms-reveal,
        input::-ms-clear {
            display: none;
        }
    </style>

    <form method="POST" action="{{ route('login') }}" class="space-y-8">
        @csrf
        <!-- Honeypot -->
        <div style="display: none;">
            <input type="text" name="honey_pot" value="">
        </div>

        <!-- Email Address -->
        <div class="space-y-3">
            <label for="email" class="block text-[10px] font-black uppercase tracking-[0.3em] text-[#D4AF37] ml-2">Email
                Address</label>
            <input id="email"
                class="block w-full bg-white/5 border border-white/10 rounded-[1.5rem] py-5 px-8 text-white placeholder-gray-600 focus:bg-white/10 focus:ring-0 focus:border-[#D4AF37] transition-all outline-none font-medium"
                type="email" name="email" :value="old('email')" placeholder="Enter your email" required autofocus
                autocomplete="username" />
            <x-input-error :messages="$errors->get('email')" class="mt-2" />
        </div>

        <!-- Password -->
        <div class="space-y-3">
            <div class="flex justify-between items-center px-2">
                <label for="password"
                    class="block text-[10px] font-black uppercase tracking-[0.3em] text-[#D4AF37]">Password</label>
                @if (Route::has('password.request'))
                    <a class="text-[9px] font-black uppercase tracking-widest text-gray-500 hover:text-white transition-colors"
                        href="{{ route('password.request') }}">
                        Forgot your password?
                    </a>
                @endif
            </div>
            <div class="relative group/pass">
                <input id="password"
                    class="block w-full bg-white/5 border border-white/10 rounded-[1.5rem] py-5 pl-8 pr-12 text-white placeholder-gray-600 focus:bg-white/10 focus:ring-0 focus:border-[#D4AF37] transition-all outline-none font-medium"
                    type="password" name="password" placeholder="••••••••" required autocomplete="current-password" />
                <button type="button" onclick="togglePassword('password', this)" style="right: 1.5rem !important;"
                    class="absolute top-1/2 -translate-y-1/2 p-2 z-10 text-gray-500 hover:text-[#D4AF37] transition-colors focus:outline-none">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M15 12a3 3 0 11-6 0 3 3 0 016 0z" />
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z" />
                    </svg>
                </button>
            </div>
            <x-input-error :messages="$errors->get('password')" class="mt-2" />
        </div>

        <!-- Remember Me -->
        <div class="block px-2">
            <label for="remember_me" class="inline-flex items-center cursor-pointer group">
                <div class="relative flex items-center">
                    <input id="remember_me" type="checkbox"
                        class="rounded border-white/20 bg-white/5 text-[#D4AF37] focus:ring-[#D4AF37] transition w-5 h-5"
                        name="remember">
                </div>
                <span
                    class="ms-4 text-[10px] font-black text-gray-500 group-hover:text-white transition-colors uppercase tracking-widest">Remember
                    me</span>
            </label>
        </div>

        <div class="pt-4">
            <button type="submit"
                class="w-full v2-gradient py-6 rounded-full text-white font-black uppercase tracking-[0.3em] text-[10px] shadow-2xl gold-glow hover:scale-[1.02] transition active:scale-95 group">
                {{ __('Log in') }}
                <span class="inline-block ml-2 group-hover:translate-x-1 transition-transform">→</span>
            </button>
        </div>

        <p
            class="text-center text-[9px] font-black text-gray-500 uppercase tracking-widest pt-10 border-t border-white/5">
            Don't have an account?
            <a href="{{ route('register') }}"
                class="text-[#D4AF37] hover:text-white transition-colors underline underline-offset-8 font-black ml-3">Register</a>
        </p>
    </form>
</x-guest-layout>