<x-guest-layout>
    <div class="mb-10 lg:text-left">
        <h2 class="text-4xl md:text-5xl font-black text-white tracking-tight mb-3 italic">Forgot <span
                class="accent-text">Password</span></h2>
        <p class="text-gray-400 font-bold text-base md:text-lg leading-relaxed uppercase tracking-widest text-[10px]">
            Recover your account</p>
    </div>

    <div class="mb-8 text-xs font-medium text-gray-400 leading-relaxed uppercase tracking-widest">
        {{ __('Forgot your password? No problem. Just let us know your email address and we will email you a password reset link that will allow you to choose a new one.') }}
    </div>

    <!-- Session Status -->
    <x-auth-session-status class="mb-6" :status="session('status')" />

    <form method="POST" action="{{ route('password.email') }}" class="space-y-8">
        @csrf

        <!-- Email Address -->
        <div class="space-y-3">
            <label for="email" class="block text-[10px] font-black uppercase tracking-[0.3em] text-[#D4AF37] ml-2">Email
                Address</label>
            <input id="email"
                class="block w-full bg-white/5 border border-white/10 rounded-[1.5rem] py-5 px-8 text-white placeholder-gray-600 focus:bg-white/10 focus:ring-0 focus:border-[#D4AF37] transition-all outline-none font-medium"
                type="email" name="email" :value="old('email')" placeholder="Enter your email" required autofocus />
            <x-input-error :messages="$errors->get('email')" class="mt-2" />
        </div>

        <div class="pt-4">
            <button type="submit"
                class="w-full v2-gradient py-6 rounded-full text-white font-black uppercase tracking-[0.3em] text-[10px] shadow-2xl gold-glow hover:scale-[1.02] transition active:scale-95 group text-center">
                {{ __('Email Password Reset Link') }}
                <span class="inline-block ml-2 group-hover:translate-x-1 transition-transform">→</span>
            </button>
        </div>

        <p
            class="text-center text-[9px] font-black text-gray-500 uppercase tracking-widest pt-10 border-t border-white/5">
            Remember your password?
            <a href="{{ route('login') }}"
                class="text-[#D4AF37] hover:text-white transition-colors underline underline-offset-8 font-black ml-3">Log
                in</a>
        </p>
    </form>
</x-guest-layout>