<x-app-layout>
    <div class="min-h-screen bg-[#020617] py-12">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">

            <div class="space-y-8">
                <div class="flex items-center justify-between px-6">
                    <h3 class="font-black text-3xl text-white tracking-tight italic">Review <span
                            class="accent-text">Submissions</span></h3>
                    <p class="text-[10px] font-black text-gray-500 uppercase tracking-[0.4em] italic">Submission Queue
                    </p>
                </div>

                <div class="glass-card rounded-[3rem] border border-white/5 overflow-hidden">
                    <div class="overflow-x-auto">
                        <table class="w-full">
                            <thead class="bg-white/5 border-b border-white/5">
                                <tr>
                                    <th
                                        class="px-10 py-6 text-left text-[10px] font-black text-gray-400 uppercase tracking-[0.3em] italic">
                                        Promoter</th>
                                    <th
                                        class="px-10 py-6 text-left text-[10px] font-black text-gray-400 uppercase tracking-[0.3em] italic">
                                        Campaign ID</th>
                                    <th
                                        class="px-10 py-6 text-left text-[10px] font-black text-gray-400 uppercase tracking-[0.3em] italic">
                                        Status</th>
                                    <th
                                        class="px-10 py-6 text-right text-[10px] font-black text-gray-400 uppercase tracking-[0.3em] italic">
                                        Actions</th>
                                </tr>
                            </thead>
                            <tbody class="divide-y divide-white/5">
                                @forelse($submissions as $submission)
                                    <tr class="hover:bg-white/[0.02] transition-all duration-300 group">
                                        <td class="px-10 py-8">
                                            <div class="flex items-center gap-6">
                                                <div
                                                    class="w-14 h-14 bg-white/5 rounded-2xl flex items-center justify-center text-gray-500 font-black border border-white/5 group-hover:bg-[#D4AF37] group-hover:text-white group-hover:border-[#D4AF37] transition-all duration-500 shadow-lg">
                                                    {{ substr($submission->promoter->name, 0, 1) }}
                                                </div>
                                                <div>
                                                    <p
                                                        class="font-black text-white tracking-tight text-lg italic uppercase">
                                                        {{ $submission->promoter->name }}
                                                    </p>
                                                    <p
                                                        class="text-[9px] font-black text-[#D4AF37] uppercase tracking-[0.2em] mt-1 opacity-80 italic">
                                                        Trust Score: {{ $submission->promoter->trust_score }}%</p>
                                                </div>
                                            </div>
                                        </td>
                                        <td class="px-10 py-8">
                                            <p class="font-black text-white text-sm tracking-tight italic">
                                                {{ $submission->campaign->title }}
                                            </p>
                                            <a href="{{ Storage::url($submission->screenshot_path) }}" target="_blank"
                                                class="inline-flex items-center gap-2 px-4 py-2 bg-white/5 border border-white/10 rounded-lg text-[9px] font-black text-indigo-400 uppercase tracking-widest hover:bg-indigo-500 hover:text-white transition-all duration-300 mt-2 group/link">
                                                <svg class="w-3 h-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                        d="M4 16l4.586-4.586a2 2 0 012.828 0L16 16m-2-2l1.586-1.586a2 2 0 012.828 0L20 14m-6-6h.01M6 20h12a2 2 0 002-2V6a2 2 0 00-2-2H6a2 2 0 00-2 2v12a2 2 0 002 2z" />
                                                </svg>
                                                View Proof
                                            </a>
                                        </td>
                                        <td class="px-10 py-8">
                                            <span @class([
                                                'text-[9px] font-black uppercase tracking-[0.2em] px-4 py-2 rounded-full border shadow-sm',
                                                'bg-yellow-500/10 text-yellow-400 border-yellow-500/20' => $submission->status === 'pending',
                                                'bg-green-500/10 text-green-400 border-green-500/20' => $submission->status === 'approved',
                                                'bg-red-500/10 text-red-500 border-red-500/20' => $submission->status === 'rejected',
                                            ])>
                                                {{ $submission->status }}
                                            </span>
                                        </td>
                                        <td class="px-10 py-8 text-right">
                                            @if($submission->status === 'pending')
                                                <div class="flex flex-col sm:flex-row items-center justify-end gap-6">
                                                    <form action="{{ route('admin.submissions.approve', $submission) }}"
                                                        method="POST" class="flex items-center gap-3">
                                                        @csrf
                                                        <input type="number" name="member_growth" placeholder="Count"
                                                            class="w-16 bg-white/5 border border-white/10 rounded-xl px-3 py-2 text-[10px] font-black text-white focus:border-[#D4AF37] focus:ring-0 outline-none tabular-nums"
                                                            value="1">
                                                        <button type="submit"
                                                            class="bg-white/10 text-white px-6 py-2.5 rounded-xl text-[9px] font-black uppercase tracking-widest hover:bg-[#D4AF37] hover:text-white transition-all duration-300 shadow-xl border border-white/5 hover:border-[#D4AF37]">
                                                            Approve
                                                        </button>
                                                    </form>

                                                    <button
                                                        onclick="document.getElementById('reject-form-{{ $submission->id }}').classList.toggle('hidden')"
                                                        class="text-red-500 hover:text-red-400 text-[9px] font-black uppercase tracking-widest transition-colors italic">
                                                        Reject
                                                    </button>
                                                </div>

                                                <form id="reject-form-{{ $submission->id }}"
                                                    action="{{ route('admin.submissions.reject', $submission) }}" method="POST"
                                                    class="hidden mt-6 animate-in slide-in-from-top duration-300">
                                                    @csrf
                                                    <div class="flex gap-3">
                                                        <input type="text" name="comment" placeholder="Reason for rejection..."
                                                            class="w-full bg-white/5 border border-white/10 rounded-xl px-5 py-3 text-[10px] font-black text-white focus:border-red-500 focus:ring-0 outline-none placeholder-gray-800"
                                                            required>
                                                        <button type="submit"
                                                            class="bg-red-500/20 text-red-400 border border-red-500/20 px-6 py-2 rounded-xl text-[9px] font-black uppercase tracking-widest hover:bg-red-500 hover:text-white transition-all duration-300 shadow-xl">
                                                            Reject
                                                        </button>
                                                    </div>
                                                </form>
                                            @else
                                                <div class="flex items-center justify-end gap-3 opacity-30">
                                                    <div class="w-1.5 h-1.5 bg-gray-500 rounded-full italic"></div>
                                                    <span
                                                        class="text-[9px] font-black text-gray-500 uppercase tracking-widest italic">Archived</span>
                                                </div>
                                            @endif
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="5" class="px-10 py-32 text-center">
                                            <div
                                                class="w-24 h-24 bg-white/5 rounded-[2rem] flex items-center justify-center mx-auto mb-8 text-gray-600 border border-white/5">
                                                <svg class="w-12 h-12 opacity-20" fill="none" stroke="currentColor"
                                                    viewBox="0 0 24 24">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5"
                                                        d="M12 4v16m8-8H4" />
                                                </svg>
                                            </div>
                                            <h5 class="text-white font-black text-2xl mb-3 tracking-tight italic">No
                                                Submissions</h5>
                                            <p
                                                class="text-gray-500 font-black text-[10px] uppercase tracking-[0.3em] max-w-xs mx-auto leading-relaxed italic">
                                                There are no submissions to review.</p>
                                        </td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>

                    @if($submissions->hasPages())
                        <div class="px-10 py-10 bg-white/[0.01] border-t border-white/5">
                            {{ $submissions->links() }}
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</x-app-layout>