<x-app-layout>
    <x-slot name="header">
        <div class="flex justify-between items-center py-4">
            <div class="space-y-1">
                <h2 class="font-black text-4xl text-white tracking-tight">
                    Manage <span class="accent-text">Group Links</span>
                </h2>
                <p class="text-gray-500 font-bold uppercase tracking-widest text-[10px]">{{ $campaign->title }}</p>
            </div>
            <a href="{{ route('admin.campaigns.index') }}"
                class="text-[10px] font-black text-gray-400 hover:text-white uppercase tracking-widest transition-colors flex items-center gap-2">
                <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2.5" d="M10 19l-7-7m0 0l7-7m-7 7h18"/></svg>
                Back to Center</a>
        </div>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto px-6 space-y-12">
            <!-- Add Links Card -->
            <div class="glass-card rounded-[3rem] p-10 border border-white/5 relative overflow-hidden group">
                <div class="absolute -right-8 -top-8 w-40 h-40 bg-indigo-600/5 rounded-full blur-3xl group-hover:bg-indigo-600/10 transition-all"></div>
                <div class="mb-10 relative z-10">
                    <h3 class="text-2xl font-black text-white tracking-tight">Bulk <span class="accent-text">Import</span></h3>
                    <p class="text-gray-400 font-medium mt-1">Paste up to 50 links below, one per line.</p>
                </div>

                <form action="{{ route('admin.campaigns.links.store', $campaign) }}" method="POST" class="relative z-10">
                    @csrf
                    <div class="space-y-8">
                        <div>
                            <label for="links" class="block text-[10px] font-black uppercase tracking-widest text-indigo-400 mb-4 px-1">WhatsApp Group Links (One per line)</label>
                            <textarea name="links" id="links" rows="8"
                                class="w-full bg-white/5 border border-white/10 rounded-3xl p-8 text-white focus:ring-4 focus:ring-indigo-600/10 focus:border-indigo-500 transition-all font-mono text-sm placeholder-gray-600"
                                placeholder="https://chat.whatsapp.com/abc...&#10;https://chat.whatsapp.com/def..."></textarea>
                        </div>
                        <div class="flex justify-end">
                            <button type="submit"
                                class="v2-gradient text-white px-12 py-4 rounded-full text-[10px] font-black uppercase tracking-widest hover:scale-105 transition-all duration-300 shadow-xl gold-glow">
                                Import Links
                            </button>
                        </div>
                    </div>
                </form>
            </div>

            <!-- Existing Links List -->
            <div class="glass-card rounded-[3rem] p-10 border border-white/5">
                <div class="flex justify-between items-center mb-10 border-b border-white/5 pb-6">
                    <h3 class="text-xl font-black text-white tracking-tight">Active <span class="accent-text">Links</span></h3>
                    <span class="bg-white/5 px-4 py-1.5 rounded-full text-[10px] font-black text-gray-400 uppercase tracking-widest border border-white/10">{{ $campaign->links->count() }} Links</span>
                </div>

                @if($campaign->links->count() > 0)
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        @foreach($campaign->links as $link)
                            <div class="flex items-center justify-between p-6 bg-white/5 rounded-3xl border border-white/5 hover:border-indigo-500/30 transition-all group">
                                <div class="flex items-center gap-5 min-w-0">
                                    <div class="w-12 h-12 bg-green-500/10 rounded-2xl flex items-center justify-center text-green-400 border border-green-500/20 group-hover:scale-110 transition-transform">
                                        <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2.5" d="M5 13l4 4L19 7"/></svg>
                                    </div>
                                    <div class="truncate">
                                        <p class="text-white font-black tracking-tight truncate text-sm">{{ $link->group_link }}</p>
                                        <p class="text-[9px] font-black text-gray-500 uppercase tracking-widest mt-0.5">Verified Link</p>
                                    </div>
                                </div>
                                <form action="{{ route('admin.campaigns.links.destroy', $link) }}" method="POST"
                                    onsubmit="return confirm('Remove this link variant?')">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="p-3 text-gray-500 hover:text-red-500 hover:bg-red-500/10 rounded-xl transition-all">
                                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16" />
                                        </svg>
                                    </button>
                                </form>
                            </div>
                        @endforeach
                    </div>
                @else
                    <div class="text-center py-24 bg-white/5 rounded-[2rem] border-2 border-dashed border-white/5">
                        <div class="w-16 h-16 bg-white/5 rounded-full flex items-center justify-center mx-auto mb-6">
                            <span class="text-3xl opacity-30">🔗</span>
                        </div>
                        <p class="text-gray-500 font-bold uppercase tracking-widest text-[10px]">No links imported yet.</p>
                    </div>
                @endif
            </div>
        </div>
    </div>
</x-app-layout>
