<x-app-layout>
    <x-slot name="header">
        <div class="py-4">
            <h2 class="font-black text-4xl text-white tracking-tight">
                {{ __('Campaign') }} <span class="accent-text">Control Center</span>
            </h2>
        </div>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto px-6">
            <div class="glass-card rounded-[3rem] overflow-hidden border border-white/5">
                <div class="p-10 border-b border-white/5 bg-white/5">
                    <h3 class="text-xl font-black text-white tracking-tight">System-wide <span
                            class="accent-text">Campaigns</span></h3>
                </div>
                <div class="overflow-x-auto">
                    <table class="min-w-full">
                        <thead>
                            <tr class="bg-black/20">
                                <th
                                    class="px-10 py-5 text-left text-[10px] font-black text-gray-500 uppercase tracking-[0.2em]">
                                    Campaign Title</th>
                                <th
                                    class="px-10 py-5 text-left text-[10px] font-black text-gray-500 uppercase tracking-[0.2em]">
                                    Brand</th>
                                <th
                                    class="px-10 py-5 text-left text-[10px] font-black text-gray-500 uppercase tracking-[0.2em]">
                                    Rate</th>
                                <th
                                    class="px-10 py-5 text-left text-[10px] font-black text-gray-500 uppercase tracking-[0.2em]">
                                    Status</th>
                                <th
                                    class="px-10 py-5 text-right text-[10px] font-black text-gray-500 uppercase tracking-[0.2em]">
                                    Control</th>
                            </tr>
                        </thead>
                        <tbody class="divide-y divide-white/5">
                            @forelse($campaigns as $campaign)
                                <tr class="hover:bg-white/5 transition-colors group">
                                    <td class="px-10 py-6">
                                        <p
                                            class="text-sm font-black text-white tracking-tight group-hover:text-[#D4AF37] transition-colors">
                                            {{ $campaign->title }}</p>
                                    </td>
                                    <td class="px-10 py-6">
                                        <span
                                            class="text-[10px] font-black text-indigo-400 uppercase tracking-widest">{{ $campaign->brand->name }}</span>
                                    </td>
                                    <td class="px-10 py-6">
                                        <span
                                            class="text-sm font-black text-white tabular-nums">₦{{ number_format($campaign->rate_per_member, 2) }}</span>
                                    </td>
                                    <td class="px-10 py-6">
                                        <span @class([
                                            'px-4 py-1.5 rounded-full text-[9px] font-black uppercase tracking-widest',
                                            'bg-green-500/10 text-green-400 border border-green-500/20' => $campaign->status == 'active',
                                            'bg-yellow-500/10 text-yellow-400 border border-yellow-500/20' => $campaign->status == 'pending',
                                            'bg-red-500/10 text-red-400 border border-red-500/20' => $campaign->status == 'paused',
                                        ])>
                                            {{ $campaign->status }}
                                        </span>
                                    </td>
                                    <td class="px-10 py-6 text-right">
                                        <div class="flex items-center justify-end gap-3">
                                            @if($campaign->status === 'pending')
                                                <form action="{{ route('admin.campaigns.approve', $campaign) }}" method="POST">
                                                    @csrf
                                                    <button type="submit"
                                                        class="p-2 bg-green-500/10 text-green-400 border border-green-500/20 rounded-lg hover:bg-green-500 hover:text-white transition-all">
                                                        <svg class="w-4 h-4" fill="none" stroke="currentColor"
                                                            viewBox="0 0 24 24">
                                                            <path stroke-linecap="round" stroke-linejoin="round"
                                                                stroke-width="2" d="M5 13l4 4L19 7" />
                                                        </svg>
                                                    </button>
                                                </form>
                                                <form action="{{ route('admin.campaigns.reject', $campaign) }}" method="POST">
                                                    @csrf
                                                    <button type="submit"
                                                        class="p-2 bg-red-500/10 text-red-400 border border-red-500/20 rounded-lg hover:bg-red-500 hover:text-white transition-all">
                                                        <svg class="w-4 h-4" fill="none" stroke="currentColor"
                                                            viewBox="0 0 24 24">
                                                            <path stroke-linecap="round" stroke-linejoin="round"
                                                                stroke-width="2" d="M6 18L18 6M6 6l12 12" />
                                                        </svg>
                                                    </button>
                                                </form>
                                            @elseif($campaign->status === 'active')
                                                <form action="{{ route('admin.campaigns.reject', $campaign) }}" method="POST">
                                                    @csrf
                                                    <button type="submit"
                                                        class="p-2 bg-orange-500/10 text-orange-400 border border-orange-500/20 rounded-lg hover:bg-orange-500 hover:text-white transition-all">
                                                        <svg class="w-4 h-4" fill="none" stroke="currentColor"
                                                            viewBox="0 0 24 24">
                                                            <path stroke-linecap="round" stroke-linejoin="round"
                                                                stroke-width="2"
                                                                d="M10 9v6m4-6v6m7-3a9 9 0 11-18 0 9 9 0 0118 0z" />
                                                        </svg>
                                                    </button>
                                                </form>
                                            @elseif($campaign->status === 'paused')
                                                <form action="{{ route('admin.campaigns.approve', $campaign) }}" method="POST">
                                                    @csrf
                                                    <button type="submit"
                                                        class="p-2 bg-green-500/10 text-green-400 border border-green-500/20 rounded-lg hover:bg-green-500 hover:text-white transition-all">
                                                        <svg class="w-4 h-4" fill="none" stroke="currentColor"
                                                            viewBox="0 0 24 24">
                                                            <path stroke-linecap="round" stroke-linejoin="round"
                                                                stroke-width="2"
                                                                d="M14.752 11.168l-3.197-2.132A1 1 0 0010 9.87v4.263a1 1 0 001.555.832l3.197-2.132a1 1 0 000-1.664z" />
                                                        </svg>
                                                    </button>
                                                </form>
                                            @endif
                                            <a href="{{ route('admin.campaigns.links', $campaign) }}"
                                                class="text-[10px] font-black text-[#D4AF37] hover:text-white uppercase tracking-widest transition-colors border border-[#D4AF37]/30 px-6 py-2 rounded-full hover:bg-[#D4AF37]">Management</a>
                                        </div>
                                    </td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="5" class="px-10 py-16 text-center">
                                        <p class="text-gray-500 font-medium italic">No campaigns found.</p>
                                    </td>
                                </tr>
                            @endforelse
                        </tbody>
                    </table>
                    <div class="p-10 border-t border-white/5 bg-white/5">
                        {{ $campaigns->links() }}
                    </div>
                </div>
            </div>
        </div>
    </div>
</x-app-layout>