<?php

namespace Database\Seeders;

use App\Models\User;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class DatabaseSeeder extends Seeder
{
    use WithoutModelEvents;

    /**
     * Seed the application's database.
     */
    public function run(): void
    {
        User::factory()->create([
            'name' => 'Admin User',
            'email' => 'admin@market.com',
            'password' => bcrypt('password'),
            'role' => 'admin',
        ]);

        User::factory()->create([
            'name' => 'Brand User',
            'email' => 'brand@market.com',
            'password' => bcrypt('password'),
            'role' => 'brand',
        ]);

        User::factory()->create([
            'name' => 'Promoter User',
            'email' => 'promoter@market.com',
            'password' => bcrypt('password'),
            'role' => 'promoter',
        ]);
    }
}
