<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ReputationScore extends Model
{
    /** @use HasFactory<\Database\Factories\ReputationScoreFactory> */
    use HasFactory;

    protected $fillable = [
        'user_id',
        'change_amount',
        'reason',
        'submission_id',
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function submission()
    {
        return $this->belongsTo(ProofSubmission::class, 'submission_id');
    }
}
